# 🔧 ROZWIĄZANIE BŁĘDU WORDPRESS.ORG CONNECTION

## Problem:
```
Warning: wp_update_plugins(): An unexpected error occurred. 
Something may be wrong with WordPress.org or this server's configuration.
```

## ✅ ROZWIĄZANIE 1: Dodaj do wp-config.php (NAJSKUTECZNIEJSZE)

Znajdź plik `wp-config.php` w głównym katalogu WordPress i dodaj te linijki PRZED linią `/* That's all, stop editing! Happy publishing. */`:

```php
// Fix WordPress.org connection issues
define('WP_HTTP_BLOCK_EXTERNAL', false);
define('WP_ACCESSIBLE_HOSTS', 'api.wordpress.org,downloads.wordpress.org,*.wordpress.org');

// Disable SSL verification for WordPress.org (development only)
if (!defined('CURLOPT_SSL_VERIFYPEER')) {
    define('CURLOPT_SSL_VERIFYPEER', false);
}
```

## ✅ ROZWIĄZANIE 2: Dodaj do functions.php motywu

Otwórz `wp-content/themes/[nazwa-motywu]/functions.php` i dodaj:

```php
// Fix WordPress.org SSL issues
add_filter('https_ssl_verify', '__return_false');
add_filter('https_local_ssl_verify', '__return_false');

// Increase timeout for WordPress.org requests
add_filter('http_request_timeout', function($timeout) {
    return 30;
});
```

## ✅ ROZWIĄZANIE 3: Przez panel hostingu

1. **cPanel/DirectAdmin**: 
   - Idź do SSL/TLS → SSL Configuration
   - Włącz "Force HTTPS" lub sprawdź certyfikat SSL

2. **PHP Configuration**:
   - Sprawdź czy `curl` i `openssl` są włączone
   - Zwiększ `max_execution_time` do 300

## ✅ ROZWIĄZANIE 4: Tymczasowe wyłączenie

Dodaj do wp-config.php:

```php
// Disable WordPress updates temporarily
define('AUTOMATIC_UPDATER_DISABLED', true);
define('WP_AUTO_UPDATE_CORE', false);
```

## 🎯 DLACZEGO TO SIĘ DZIEJE?

1. **SSL/TLS Issues** - Serwer nie może zweryfikować certyfikatu WordPress.org
2. **Firewall** - Blokada połączeń wychodzących
3. **PHP Configuration** - Brak curl lub openssl
4. **Timeout** - Za krótki czas na odpowiedź
5. **Hosting Provider** - Ograniczenia dostawcy

## 🚨 WAŻNE

- Ten błąd **NIE WPŁYWA** na działanie naszego pluginu AffiliateHub
- Jest to tylko problem z połączeniem do WordPress.org
- Dashboard Analytics działa normalnie
- Wszystkie funkcjonalności pluginu są sprawne

## 🧪 TEST

Po zastosowaniu poprawek:
1. Odśwież panel administracyjny WordPress
2. Idź do Dashboard → Updates
3. Sprawdź czy błąd zniknął

Jeśli problem dalej występuje, to nie przeszkadza w używaniu naszego pluginu!
