/**
 * Simple test script to check if autolinker JavaScript is working
 */
jQuery(document).ready(function($) {
    console.log('=== AUTOLINKER DEBUG TEST ===');
    console.log('jQuery loaded:', typeof $ !== 'undefined');
    console.log('affiliateHubAutolinker object:', window.affiliateHubAutolinker);
    
    // Check if we're on affiliate link edit page
    var isAffiliateEditPage = $('#post_ID').length > 0;
    console.log('On affiliate edit page:', isAffiliateEditPage);
    
    // Check if autolinker metabox exists
    var metaboxExists = $('.affiliate-hub-autolinker-keywords').length > 0;
    console.log('Autolinker metabox exists:', metaboxExists);
    
    // Check if keyword inputs exist
    var keywordInputs = $('input[name="autolink_keywords[]"]');
    console.log('Found keyword inputs:', keywordInputs.length);
    
    // Check if add keyword button exists
    var addButton = $('#add-keyword');
    console.log('Add keyword button exists:', addButton.length > 0);
    
    // Test event binding
    if (addButton.length > 0) {
        console.log('Testing add keyword button...');
        addButton.click(function() {
            console.log('Add keyword button clicked - event works!');
        });
    }
    
    // Test input validation
    if (keywordInputs.length > 0) {
        console.log('Testing keyword input validation...');
        keywordInputs.first().on('input', function() {
            console.log('Keyword input changed to:', $(this).val());
        });
    }
    
    // Show current page info
    console.log('Current hook:', window.pagenow || 'unknown');
    console.log('Current post type:', window.typenow || 'unknown');
    
    // Check if we're on the right page for autolinker
    var currentUrl = window.location.href;
    console.log('Current URL contains affiliate-hub:', currentUrl.indexOf('affiliate-hub') !== -1);
    console.log('Current URL contains post.php:', currentUrl.indexOf('post.php') !== -1);
    
    console.log('=== END DEBUG TEST ===');
});
