/*!
 * Chart.js v3.9.1 - Local version for Affiliate Hub
 * This file should contain the full Chart.js library
 * For now, it will trigger CDN fallback loading
 */

(function() {
    // If Chart.js hasn't loaded yet, try to load it from CDN
    if (typeof Chart === 'undefined') {
        console.log('Local Chart.js placeholder - triggering CDN fallback');
        
        // Create a script element to load Chart.js from CDN
        var script = document.createElement('script');
        script.src = 'https://cdn.jsdelivr.net/npm/chart.js@3.9.1/dist/chart.min.js';
        script.onload = function() {
            console.log('Chart.js loaded successfully from CDN');
            // Dispatch event to notify that Chart.js is ready
            if (typeof window.AffiliateStatsChartReady === 'function') {
                window.AffiliateStatsChartReady();
            }
        };
        script.onerror = function() {
            console.warn('Failed to load Chart.js from CDN');
        };
        
        // Add to head
        document.head.appendChild(script);
    } else {
        console.log('Chart.js already loaded');
    }
})();
