/**
 * Simple debug test for Keywords Autolinker
 */
jQuery(document).ready(function($) {
    console.log('=== AUTOLINKER DEBUG START ===');
    
    // 1. Check basic elements
    console.log('Keyword inputs found:', $('input[name="autolink_keywords[]"]').length);
    console.log('Add button found:', $('#add-keyword').length);
    console.log('Container found:', $('#autolink-keywords-container').length);
    
    // 2. Check existing keyword tags structure
    $('.keyword-tag').each(function(index) {
        var $tag = $(this);
        console.log('Tag', index + ':', {
            hasWrapper: $tag.find('.keyword-input-wrapper').length > 0,
            hasStatusMessage: $tag.find('.keyword-status-message').length > 0,
            keywordValue: $tag.find('input').val(),
            inputCount: $tag.find('input').length
        });
    });
    
    // 3. Test add keyword button manually
    $('#add-keyword').click(function() {
        console.log('Add keyword button clicked!');
    });
    
    // 4. Test input validation manually  
    $('input[name="autolink_keywords[]"]').on('input', function() {
        console.log('Input changed:', $(this).val());
    });
    
    // 5. Check post ID fields
    console.log('post_ID field (#post_ID):', $('#post_ID').length > 0 ? $('#post_ID').val() : 'NOT FOUND');
    console.log('ID field (#ID):', $('#ID').length > 0 ? $('#ID').val() : 'NOT FOUND');
    console.log('post ID field (#post):', $('#post').length > 0 ? $('#post').val() : 'NOT FOUND');
    console.log('All hidden inputs:', $('input[type="hidden"]').length);
    $('input[type="hidden"]').each(function() {
        if ($(this).attr('name') && $(this).attr('name').indexOf('ID') !== -1) {
            console.log('Hidden field with ID:', $(this).attr('name'), '=', $(this).val());
        }
    });

    // 6. Check affiliateHubAutolinker object
    console.log('affiliateHubAutolinker available:', typeof window.affiliateHubAutolinker !== 'undefined');
    if (window.affiliateHubAutolinker) {
        console.log('AJAX URL:', window.affiliateHubAutolinker.ajaxUrl);
        console.log('Nonce:', window.affiliateHubAutolinker.nonce);
    }
    
    console.log('=== AUTOLINKER DEBUG END ===');
});
