/**
 * Debug test for Keywords Autolinker specific issues
 */
jQuery(document).ready(function($) {
    console.log('=== DEBUGGING AUTOLINKER ISSUES ===');

    // Test 1: Check if Add Keyword button creates multiple handlers
    var clickCount = 0;
    $('#add-keyword').off('click.debug').on('click.debug', function() {
        clickCount++;
        console.log('🔧 Add keyword clicked - count:', clickCount);
        if (clickCount > 1) {
            console.error('🚨 MULTIPLE HANDLERS DETECTED ON ADD KEYWORD BUTTON!');
        }
    });

    // Test 2: Check validation on manual input change
    setTimeout(function() {
        console.log('=== MANUAL VALIDATION TEST ===');
        var $firstInput = $('input[name="autolink_keywords[]"]').first();
        if ($firstInput.length) {
            console.log('Testing validation on first input...');
            $firstInput.val('privacy').trigger('input');
            
            setTimeout(function() {
                var $secondInput = $('input[name="autolink_keywords[]"]').eq(1);
                if ($secondInput.length) {
                    console.log('Testing duplicate detection...');
                    $secondInput.val('privacy').trigger('input');
                } else {
                    console.log('No second input available for duplicate test');
                }
            }, 1000);
        }
    }, 2000);

    // Test 3: Count all event handlers on input fields
    setTimeout(function() {
        console.log('=== EVENT HANDLERS COUNT ===');
        $('input[name="autolink_keywords[]"]').each(function(index) {
            var events = $._data(this, 'events');
            console.log('Input', index, 'events:', events ? Object.keys(events) : 'none');
        });
    }, 3000);

    console.log('=== DEBUG TESTS INITIALIZED ===');
});
