/**
 * Frontend JavaScript for Affiliate Hub
 */
(function($) {
    'use strict';

    // Check if required objects exist
    if (typeof affiliateHub === 'undefined') {
        return;
    }

    var AffiliateHub = {
        init: function() {
            this.bindEvents();
        },

        bindEvents: function() {
            // Track affiliate link clicks
            $(document).on('click', '.affiliate-link', this.trackClick);
            
            // Handle shortcode links
            $(document).on('click', '[data-affiliate-id]', this.handleShortcodeClick);
        },

        trackClick: function(e) {
            var $link = $(this);
            var linkId = $link.data('link-id') || $link.data('affiliate-id');
            var href = $link.attr('href');
            
            if (!linkId || !href || !affiliateHub.ajaxUrl) {
                return true; // Let the link work normally
            }

            // DON'T prevent default - let link work naturally
            // Just track the click in background
            $link.addClass('tracking');

            // Track the click asynchronously, don't block navigation
            $.ajax({
                url: affiliateHub.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'affiliate_hub_track_click',
                    link_id: linkId,
                    nonce: affiliateHub.nonce, // Use own nonce
                    referrer: document.referrer,
                    user_agent: navigator.userAgent
                },
                async: true, // Make sure it's async
                complete: function() {
                    $link.removeClass('tracking');
                }
            });

            // Let the browser handle the link normally
            return true;
        },

        handleShortcodeClick: function(e) {
            var $element = $(this);
            var linkId = $element.data('affiliate-id');
            var href = $element.attr('href');
            
            if (!linkId || !href || !affiliateHub.ajaxUrl) {
                return true; // Let the link work normally
            }

            // DON'T prevent default - let link work naturally
            // Just track the click in background
            $element.addClass('tracking');

            // Track the click asynchronously, don't block navigation
            $.ajax({
                url: affiliateHub.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'affiliate_hub_track_click',
                    link_id: linkId,
                    nonce: affiliateHub.nonce, // Use own nonce
                    referrer: document.referrer,
                    user_agent: navigator.userAgent
                },
                async: true, // Make sure it's async
                complete: function() {
                    $element.removeClass('tracking');
                }
            });

            // Let the browser handle the link normally
            return true;
        }
    };

    // Initialize when document is ready
    $(document).ready(function() {
        AffiliateHub.init();
    });

})(jQuery);
