<?php
/**
 * Debug script to check browser data in database
 */

// Include WordPress
require_once dirname(__FILE__, 4) . '/wp-config.php';

global $wpdb;

// Check recent clicks and their browser data
$table_clicks = $wpdb->prefix . 'affiliate_hub_link_clicks';

echo "=== BROWSER DATA DEBUG ===\n";

// Get last 10 records
$recent_clicks = $wpdb->get_results(
    "SELECT id, clicked_at, link_id, browser, browser_version, device_type, user_agent 
     FROM $table_clicks 
     ORDER BY clicked_at DESC 
     LIMIT 10",
    ARRAY_A
);

echo "Recent clicks count: " . count($recent_clicks) . "\n\n";

foreach ($recent_clicks as $click) {
    echo "ID: {$click['id']}\n";
    echo "Time: {$click['clicked_at']}\n";
    echo "Link ID: {$click['link_id']}\n";
    echo "Browser: '{$click['browser']}'\n";
    echo "Browser Version: '{$click['browser_version']}'\n";
    echo "Device: '{$click['device_type']}'\n";
    echo "User Agent: '{$click['user_agent']}'\n";
    echo "---\n";
}

// Test UserAgentParser directly
echo "\n=== TESTING USER AGENT PARSER ===\n";

require_once __DIR__ . '/includes/Modules/UserAgentParser.php';

$parser = new \AffiliateHub\Modules\UserAgentParser();

// Test with Chrome user agent
$test_ua = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/118.0.0.0 Safari/537.36';

echo "Test UA: $test_ua\n";

try {
    $parsed = $parser->parse($test_ua);
    echo "Parsed result:\n";
    print_r($parsed);
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}

echo "\n=== DONE ===\n";
