<?php
/**
 * Test direct browser data
 */

// Set up WordPress environment
define('WP_USE_THEMES', false);
require_once 'wp-config.php';

global $wpdb;

echo "=== BROWSER DATA DEBUG ===\n";

// Check table structure
$table_clicks = $wpdb->prefix . 'affiliate_hub_link_clicks';
echo "Table: $table_clicks\n";

// Check if table exists
$table_exists = $wpdb->get_var("SHOW TABLES LIKE '$table_clicks'");
if (!$table_exists) {
    echo "ERROR: Table $table_clicks does not exist!\n";
    exit;
}

// Get latest 5 records with browser data
$results = $wpdb->get_results(
    "SELECT id, clicked_at, link_id, browser, browser_version, device_type, user_agent 
     FROM $table_clicks 
     ORDER BY id DESC 
     LIMIT 5",
    ARRAY_A
);

echo "\nLatest 5 records:\n";
foreach ($results as $i => $row) {
    echo "\n--- Record " . ($i + 1) . " ---\n";
    echo "ID: {$row['id']}\n";
    echo "Time: {$row['clicked_at']}\n";
    echo "Browser: '{$row['browser']}'\n";
    echo "Browser Version: '{$row['browser_version']}'\n";
    echo "Device: '{$row['device_type']}'\n";
    echo "User Agent: '{$row['user_agent']}'\n";
}

// Test UserAgentParser
echo "\n=== TESTING USERAGENTPARSER ===\n";

// Include the class
require_once __DIR__ . '/includes/Modules/UserAgentParser.php';

$parser = new \AffiliateHub\Modules\UserAgentParser();

// Get a real User Agent from the database
$real_ua = '';
if (!empty($results)) {
    $real_ua = $results[0]['user_agent'];
}

if (empty($real_ua)) {
    $real_ua = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/118.0.0.0 Safari/537.36';
}

echo "Testing with UA: $real_ua\n";

try {
    $parsed = $parser->parse($real_ua);
    echo "Parsed successfully:\n";
    print_r($parsed);
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
}

echo "\n=== DONE ===\n";
