<?php
/**
 * Debug script to check clicks discrepancy between meta fields and database table
 */

// WordPress functions
require_once('../../../wp-config.php');
require_once('../../../wp-load.php');

// Include our constants
require_once('includes/Core/Constants.php');
use AffiliateHub\Core\Constants;

global $wpdb;

echo "<h2>🔍 DEBUG CLICKS DISCREPANCY</h2>\n";

// WhitePress link ID from attachment
$link_id = 461;

echo "<h3>Link ID: $link_id (WhitePress)</h3>\n";

// Check meta field value
$meta_click_count = get_post_meta($link_id, Constants::META_CLICK_COUNT, true);
echo "<p><strong>Meta field (_affiliate_click_count):</strong> " . intval($meta_click_count) . "</p>\n";

// Check table count
$table_clicks = $wpdb->prefix . Constants::TABLE_LINK_CLICKS;
$table_count = $wpdb->get_var($wpdb->prepare(
    "SELECT COUNT(*) FROM $table_clicks WHERE link_id = %d",
    $link_id
));
echo "<p><strong>Table count (affiliate_hub_link_clicks):</strong> " . intval($table_count) . "</p>\n";

// Check unique clicks
$unique_count = $wpdb->get_var($wpdb->prepare(
    "SELECT COUNT(DISTINCT ip_address) FROM $table_clicks WHERE link_id = %d",
    $link_id
));
echo "<p><strong>Unique clicks (DISTINCT ip_address):</strong> " . intval($unique_count) . "</p>\n";

echo "<h3>📊 DISCREPANCY ANALYSIS</h3>\n";
$difference = intval($table_count) - intval($meta_click_count);
echo "<p><strong>Difference:</strong> $difference clicks</p>\n";

if ($difference > 0) {
    echo "<p>🚨 <strong>Table has MORE clicks than meta field</strong></p>\n";
    echo "<p>This means some clicks were recorded in table but didn't update meta field.</p>\n";
    
    // Get recent clicks for this link
    echo "<h3>🕐 RECENT CLICKS FOR THIS LINK</h3>\n";
    $recent_clicks = $wpdb->get_results($wpdb->prepare(
        "SELECT id, clicked_at, ip_address, browser, source FROM $table_clicks 
         WHERE link_id = %d 
         ORDER BY clicked_at DESC 
         LIMIT 10",
        $link_id
    ), ARRAY_A);
    
    echo "<table border='1' style='border-collapse: collapse;'>\n";
    echo "<tr><th>ID</th><th>Date</th><th>IP</th><th>Browser</th><th>Source</th></tr>\n";
    foreach ($recent_clicks as $click) {
        echo "<tr>";
        echo "<td>" . $click['id'] . "</td>";
        echo "<td>" . $click['clicked_at'] . "</td>";
        echo "<td>" . $click['ip_address'] . "</td>";
        echo "<td>" . ($click['browser'] ?? 'N/A') . "</td>";
        echo "<td>" . ($click['source'] ?? 'N/A') . "</td>";
        echo "</tr>\n";
    }
    echo "</table>\n";
    
} elseif ($difference < 0) {
    echo "<p>🚨 <strong>Meta field has MORE clicks than table</strong></p>\n";
    echo "<p>This means meta field was incremented but clicks weren't stored in table.</p>\n";
} else {
    echo "<p>✅ <strong>No discrepancy - both sources match</strong></p>\n";
}

// Check other links for comparison
echo "<h3>🔍 OTHER LINKS COMPARISON</h3>\n";
$other_links = $wpdb->get_results(
    "SELECT p.ID, p.post_title, 
            (SELECT meta_value FROM {$wpdb->postmeta} WHERE post_id = p.ID AND meta_key = '" . Constants::META_CLICK_COUNT . "') as meta_clicks,
            (SELECT COUNT(*) FROM $table_clicks WHERE link_id = p.ID) as table_clicks
     FROM {$wpdb->posts} p 
     WHERE p.post_type = '" . Constants::POST_TYPE_AFFILIATE_LINK . "'
     AND p.post_status = 'publish'
     LIMIT 10",
    ARRAY_A
);

echo "<table border='1' style='border-collapse: collapse;'>\n";
echo "<tr><th>ID</th><th>Title</th><th>Meta Clicks</th><th>Table Clicks</th><th>Difference</th></tr>\n";
foreach ($other_links as $link) {
    $meta = intval($link['meta_clicks']);
    $table = intval($link['table_clicks']);
    $diff = $table - $meta;
    $color = $diff != 0 ? 'style="background-color: #ffcccc;"' : '';
    
    echo "<tr $color>";
    echo "<td>" . $link['ID'] . "</td>";
    echo "<td>" . $link['post_title'] . "</td>";
    echo "<td>" . $meta . "</td>";
    echo "<td>" . $table . "</td>";
    echo "<td>" . ($diff > 0 ? "+$diff" : $diff) . "</td>";
    echo "</tr>\n";
}
echo "</table>\n";
?>
