<?php
/**
 * Temporary debug action for testing UserAgentParser
 * Add this to functions.php or activate as plugin
 */

add_action('wp_ajax_test_useragent', 'test_useragent_ajax');
add_action('wp_ajax_nopriv_test_useragent', 'test_useragent_ajax');

function test_useragent_ajax() {
    // Include UserAgentParser
    if (!class_exists('AffiliateHub\Modules\UserAgentParser')) {
        wp_die('UserAgentParser class not found');
    }
    
    $parser = new \AffiliateHub\Modules\UserAgentParser();
    
    $test_ua = $_GET['ua'] ?? 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/118.0.0.0 Safari/537.36';
    
    try {
        $result = $parser->parse($test_ua);
        
        header('Content-Type: application/json');
        echo json_encode([
            'success' => true,
            'user_agent' => $test_ua,
            'parsed' => $result
        ]);
    } catch (Exception $e) {
        header('Content-Type: application/json');
        echo json_encode([
            'success' => false,
            'error' => $e->getMessage(),
            'user_agent' => $test_ua
        ]);
    }
    
    wp_die();
}

// Add admin menu for easy testing
add_action('admin_menu', function() {
    add_submenu_page(
        'tools.php',
        'UA Test',
        'UA Test',
        'manage_options',
        'ua-test',
        function() {
            echo '<div class="wrap">';
            echo '<h1>UserAgent Parser Test</h1>';
            echo '<p><a href="' . admin_url('admin-ajax.php?action=test_useragent') . '" target="_blank">Test UserAgent Parser</a></p>';
            echo '</div>';
        }
    );
});
