<?php
/**
 * Plugin Constants
 *
 * @package AffiliateHub
 * @subpackage Core
 */

namespace AffiliateHub\Core;

/**
 * Constants class for the plugin
 */
class Constants {
    
    /**
     * Post type for affiliate links
     */
    const POST_TYPE_AFFILIATE_LINK = 'affiliate_link';
    
    /**
     * Taxonomy for affiliate link categories
     */
    const TAXONOMY_AFFILIATE_CATEGORY = 'affiliate_category';
    
    /**
     * Taxonomy for affiliate link tags
     */
    const TAXONOMY_AFFILIATE_TAG = 'affiliate_tag';
    
    /**
     * Database table names
     */
    const TABLE_LINK_CLICKS = 'affiliate_hub_link_clicks';
    const TABLE_CLICK_META = 'affiliate_hub_click_meta';
    const TABLE_LINK_SCANS = 'affiliate_hub_link_scans';
    const TABLE_SCANNED_LINKS = 'affiliate_hub_scanned_links';
    const TABLE_AUTOLINKER_CACHE = 'affiliate_hub_autolinker_cache';
    
    /**
     * Options
     */
    const OPTION_VERSION = 'affiliate_hub_version';
    const OPTION_LINK_PREFIX = 'affiliate_hub_link_prefix';
    const OPTION_REDIRECT_TYPE = 'affiliate_hub_redirect_type';
    const OPTION_ENABLE_STATS = 'affiliate_hub_enable_stats';
    const OPTION_NOFOLLOW_LINKS = 'affiliate_hub_nofollow_links';
    const OPTION_SPONSORED_LINKS = 'affiliate_hub_sponsored_links';
    const OPTION_TRACKING_LINKS = 'affiliate_hub_tracking_links';
    const OPTION_OPEN_NEW_WINDOW = 'affiliate_hub_open_new_window';
    const OPTION_ENABLE_FAST_REDIRECT = 'affiliate_hub_enable_fast_redirect';
    const OPTION_LINK_SCANNER_WHITELIST = 'affiliate_hub_linkscanner_whitelist';
    const OPTION_LINK_SCANNER_BLACKLIST = 'affiliate_hub_linkscanner_blacklist';
    const OPTION_LINK_SCANNER_RATE = 'affiliate_hub_linkscanner_rate';
    const OPTION_LINK_SCANNER_DISABLE_ANIMATIONS = 'affiliate_hub_linkscanner_disable_animations';
    const OPTION_LINK_SCANNER_DEBOUNCE_MS = 'affiliate_hub_linkscanner_debounce_ms';
    
    // Keywords Autolinker options
    const OPTION_AUTOLINKER_ENABLED = 'affiliate_hub_autolinker_enabled';
    const OPTION_AUTOLINKER_KEYWORD_LIMIT = 'affiliate_hub_autolinker_keyword_limit';
    const OPTION_AUTOLINKER_RANDOM_PLACEMENT = 'affiliate_hub_autolinker_random_placement';
    const OPTION_AUTOLINKER_LINK_IN_HEADINGS = 'affiliate_hub_autolinker_link_in_headings';
    const OPTION_AUTOLINKER_DISABLE_ARCHIVE = 'affiliate_hub_autolinker_disable_archive';
    const OPTION_AUTOLINKER_DISABLE_HOME = 'affiliate_hub_autolinker_disable_home';
    const OPTION_AUTOLINKER_ENABLE_FEEDS = 'affiliate_hub_autolinker_enable_feeds';
    const OPTION_AUTOLINKER_POST_TYPES = 'affiliate_hub_autolinker_post_types';
    
    // GeoLocation module options
    const OPTION_ENABLE_GEOLOCATION = 'affiliate_hub_enable_geolocation';
    const OPTION_ANONYMIZE_IP = 'affiliate_hub_anonymize_ip';
    const OPTION_GEO_PRIMARY_PROVIDER = 'affiliate_hub_geo_primary_provider';
    const OPTION_FALLBACK_COUNTRY = 'affiliate_hub_fallback_country';
    const OPTION_FALLBACK_CITY = 'affiliate_hub_fallback_city';
    const OPTION_ENABLE_LOCAL_GEOIP = 'affiliate_hub_enable_local_geoip';
    const OPTION_GEO_CACHE_TTL = 'affiliate_hub_geo_cache_ttl';
    
    /**
     * User capabilities
     */
    const CAP_MANAGE_AFFILIATE_LINKS = 'manage_affiliate_links';
    const CAP_VIEW_AFFILIATE_STATS = 'view_affiliate_stats';
    
    /**
     * Redirect types
     */
    const REDIRECT_301 = '301';
    const REDIRECT_302 = '302';
    const REDIRECT_307 = '307';
    
    /**
     * Meta keys
     */
    const META_DESTINATION_URL = '_affiliate_destination_url';
    const META_REDIRECT_TYPE = '_affiliate_redirect_type';
    const META_NOFOLLOW = '_affiliate_nofollow';
    const META_SPONSORED = '_affiliate_sponsored';
    const META_TRACKING = '_affiliate_tracking';
    const META_NEW_WINDOW = '_affiliate_new_window';
    const META_CLICK_COUNT = '_affiliate_click_count';
    const META_UNIQUE_CLICKS = '_affiliate_unique_clicks';
    const META_LAST_CLICKED = '_affiliate_last_clicked';
    const META_CONVERSION_COUNT = '_affiliate_conversion_count';
    const META_REVENUE = '_affiliate_revenue';
    
    // Keywords Autolinker meta keys
    const META_AUTOLINK_KEYWORDS = '_affiliate_autolink_keywords';
    const META_AUTOLINK_KEYWORD_LIMIT = '_affiliate_autolink_keyword_limit';
    
    /**
     * Get available redirect types
     *
     * @return array
     */
    public static function get_redirect_types() {
        return array(
            self::REDIRECT_301 => \__('301 Permanent', 'affiliate-hub'),
            self::REDIRECT_302 => \__('302 Temporary', 'affiliate-hub'),
            self::REDIRECT_307 => \__('307 Temporary (HTTP/1.1)', 'affiliate-hub')
        );
    }
    
    /**
     * Get default options
     *
     * @return array
     */
    public static function get_default_options() {
        return array(
            self::OPTION_LINK_PREFIX => 'go',
            self::OPTION_REDIRECT_TYPE => self::REDIRECT_301,
            self::OPTION_ENABLE_STATS => true,
            self::OPTION_NOFOLLOW_LINKS => true,
            self::OPTION_SPONSORED_LINKS => false,
            self::OPTION_TRACKING_LINKS => false,
            self::OPTION_OPEN_NEW_WINDOW => false
        );
    }
}
