<?php
/**
 * Plugin Deactivator
 *
 * @package AffiliateHub
 * @subpackage Core
 */

namespace AffiliateHub\Core;

/**
 * Handles plugin deactivation
 */
class Deactivator {
    
    /**
     * Deactivate the plugin
     */
    public static function deactivate() {
        // Flush rewrite rules
        flush_rewrite_rules();
        
        // Clear any caches
        wp_cache_flush();
        
        // Remove activation flag
        delete_option('affiliate_hub_activated');
    }
}
