<?php
/**
 * Internationalization (i18n) handler
 *
 * @package AffiliateHub
 * @subpackage Core
 */

namespace AffiliateHub\Core;

/**
 * Handles plugin internationalization
 */
class I18n {
    
    /**
     * Load text domain when not auto-loaded by WordPress.org.
     * WordPress (since 4.6) auto-loads translations for .org-hosted plugins,
     * so this is only a defensive fallback for non-.org installs.
     */
    public function load_plugin_textdomain() {
        // phpcs:ignore PluginCheck.CodeAnalysis.DiscouragedFunctions.load_plugin_textdomainFound -- Fallback for non-.org installs; WP auto-loads on .org since 4.6
        \load_plugin_textdomain(
            'AffiliateHub',
            false,
            dirname(dirname(\plugin_basename(__FILE__))) . '/languages/'
        );
    }
}
