<?php
/**
 * Plugin Uninstaller
 *
 * @package AffiliateHub
 * @subpackage Core
 */

namespace AffiliateHub\Core;

use AffiliateHub\Core\Constants;

/**
 * Handles plugin uninstallation
 */
class Uninstaller {
    
    /**
     * Uninstall the plugin
     */
    public static function uninstall() {
        // Only proceed if user has permission
    if (!\current_user_can('activate_plugins')) {
            return;
        }
        
        // Check if we should remove data
    $remove_data = \get_option('affiliate_hub_remove_data_on_uninstall', false);
        
        if ($remove_data) {
            self::remove_data();
        }
    }
    
    /**
     * Remove all plugin data
     */
    private static function remove_data() {
        global $wpdb;
        
        // Remove custom post types and their meta
        $posts = \get_posts(array(
            'post_type' => Constants::POST_TYPE_AFFILIATE_LINK,
            'numberposts' => -1,
            'post_status' => 'any'
        ));
        
        foreach ($posts as $post) {
            \wp_delete_post($post->ID, true);
        }
        
        // Remove taxonomies
        $terms = \get_terms(array(
            'taxonomy' => Constants::TAXONOMY_AFFILIATE_CATEGORY,
            'hide_empty' => false
        ));
        
        foreach ($terms as $term) {
            \wp_delete_term($term->term_id, Constants::TAXONOMY_AFFILIATE_CATEGORY);
        }
        
    // Drop custom tables
    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.DirectDatabaseQuery.SchemaChange,WordPress.DB.PreparedSQL.InterpolatedNotPrepared,WordPress.DB.PreparedSQL.NotPrepared -- Intentional cleanup during uninstall: remove plugin-created tables
    $wpdb->query("DROP TABLE IF EXISTS " . $wpdb->prefix . Constants::TABLE_LINK_CLICKS);
    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,WordPress.DB.DirectDatabaseQuery.SchemaChange,WordPress.DB.PreparedSQL.InterpolatedNotPrepared,WordPress.DB.PreparedSQL.NotPrepared -- Intentional cleanup during uninstall: remove plugin-created tables
    $wpdb->query("DROP TABLE IF EXISTS " . $wpdb->prefix . Constants::TABLE_CLICK_META);
        
        // Remove options
        $options = array(
            Constants::OPTION_VERSION,
            Constants::OPTION_LINK_PREFIX,
            Constants::OPTION_REDIRECT_TYPE,
            Constants::OPTION_ENABLE_STATS,
            Constants::OPTION_NOFOLLOW_LINKS,
            Constants::OPTION_OPEN_NEW_WINDOW,
            'affiliate_hub_activated',
            'affiliate_hub_remove_data_on_uninstall'
        );
        
        foreach ($options as $option) {
            \delete_option($option);
        }
        
        // Remove capabilities
        self::remove_capabilities();
        
        // Flush rewrite rules
        \flush_rewrite_rules();
    }
    
    /**
     * Remove custom capabilities
     */
    private static function remove_capabilities() {
        $roles = array('administrator', 'editor');
        
        foreach ($roles as $role_name) {
            $role = \get_role($role_name);
            if ($role) {
                $role->remove_cap(Constants::CAP_MANAGE_AFFILIATE_LINKS);
                $role->remove_cap(Constants::CAP_VIEW_AFFILIATE_STATS);
            }
        }
    }
}
