<?php
namespace AffiliateHub\Modules\LinkScanner;

class AdminPage {
    public function render() {
        ?>
        <div class="wrap">
            <h1><?php echo \esc_html(\__('Link Scanner', 'affiliate-hub')); ?></h1>
            
            <div class="notice notice-info" style="margin-bottom: 20px;">
                <p><?php echo sprintf(
                    \__('Configure Link Scanner settings (whitelist, blacklist, scan rate) in %s.', 'affiliate-hub'),
                    '<a href="' . admin_url('edit.php?post_type=affiliate_link&page=affiliate-hub-settings') . '">' . \__('Settings', 'affiliate-hub') . '</a>'
                ); ?></p>
            </div>
            
            <div id="ah-scan-status">
                <div style="display:flex; gap:24px; align-items:flex-start;">
                    <div style="flex:0 0 360px;">
                        <h2 style="margin-top:0;"><?php echo esc_html__('Scan filters & controls', 'affiliate-hub'); ?></h2>
                        
                        <!-- Scan Type Selection -->
                        <div style="margin-bottom:15px; padding:12px; background:#f9f9f9; border:1px solid #ddd; border-radius:4px;">
                            <label style="margin-bottom:8px; display:block;"><strong><?php echo esc_html__('Scan Type', 'affiliate-hub'); ?></strong></label>
                            <label style="display:block; margin-bottom:6px;">
                                <input type="radio" name="ah-scan-type" id="ah-scan-content" value="content" checked style="margin-right:8px;">
                                <?php echo esc_html__('Scan content links (posts, pages)', 'affiliate-hub'); ?>
                            </label>
                            <label style="display:block;">
                                <input type="radio" name="ah-scan-type" id="ah-scan-affiliates" value="affiliates" style="margin-right:8px;">
                                <?php echo esc_html__('Scan affiliate links destinations', 'affiliate-hub'); ?>
                            </label>
                            <p style="margin:8px 0 0 0; color:#666; font-size:13px;">
                                <?php echo esc_html__('Content scan checks links within posts/pages. Affiliate scan checks if your affiliate link destinations are working.', 'affiliate-hub'); ?>
                            </p>
                        </div>
                        
                        <!-- Post Types (only for content scan) -->
                        <div id="ah-post-types-container" style="margin-bottom:12px;">
                            <label for="ah-post-types"><strong><?php echo esc_html__('Post types', 'affiliate-hub'); ?></strong></label>
                            <select id="ah-post-types" multiple style="width:100%; min-height:120px;" data-placeholder="<?php echo esc_attr__('Select post types', 'affiliate-hub'); ?>"></select>
                        </div>
                        
                        <div style="margin-bottom:12px; display:flex; gap:8px; align-items:center;">
                            <label for="ah-filter-status" style="margin:0;"><strong><?php echo esc_html__('Status', 'affiliate-hub'); ?></strong></label>
                            <select id="ah-filter-status" style="flex:1 1 auto;">
                                <option value=""><?php echo esc_html__('All', 'affiliate-hub'); ?></option>
                                <option value="pending"><?php echo esc_html__('Pending', 'affiliate-hub'); ?></option>
                                <option value="active"><?php echo esc_html__('Active', 'affiliate-hub'); ?></option>
                                <option value="broken"><?php echo esc_html__('Broken', 'affiliate-hub'); ?></option>
                                <option value="forbidden"><?php echo esc_html__('Forbidden', 'affiliate-hub'); ?></option>
                                <option value="skipped"><?php echo esc_html__('Skipped', 'affiliate-hub'); ?></option>
                            </select>
                        </div>
                        
                        <div style="margin-bottom:12px;">
                            <button id="ah-start-scan" class="button button-primary"><?php echo \esc_html(\__('Start Scan', 'affiliate-hub')); ?></button>
                            <button id="ah-pause-scan" class="button" style="margin-left:8px; display:none;"><?php echo esc_html__('Pause', 'affiliate-hub'); ?></button>
                            <button id="ah-resume-scan" class="button" style="margin-left:8px; display:none;"><?php echo esc_html__('Resume', 'affiliate-hub'); ?></button>
                            <button id="ah-cancel-scan" class="button" style="margin-left:8px; display:none;"><?php echo esc_html__('Cancel', 'affiliate-hub'); ?></button>
                            <button id="ah-force-finish" class="button" style="margin-left:8px; display:none; background:#e74c3c; color:#fff;"><?php echo esc_html__('Force Finish', 'affiliate-hub'); ?></button>
                        </div>
                        <div>
                            <label style="vertical-align:middle;"><input type="checkbox" id="ah-show-ignored"> <?php echo esc_html__('Show ignored links', 'affiliate-hub'); ?></label>
                        </div>
                    </div>

                    <div style="flex:1 1 auto;">
                        <h2 style="margin-top:0;"><?php echo esc_html__('Summary', 'affiliate-hub'); ?></h2>
                        <div class="chart-wrapper">
                            <div id="ah-scan-chart"></div>
                            <!-- Lightweight progress bar shown for very large scans to avoid ApexCharts work -->
                            <div id="ah-scan-progress" style="display:none; width:100%;">
                                <div class="ah-progress-track"><div class="ah-progress-fill" style="width:0%"></div></div>
                                <div class="ah-progress-text" style="margin-top:6px;font-size:13px;color:#333;">0 / 0</div>
                            </div>
                        </div>
                        <div style="margin-top:10px; display:flex; align-items:center; gap:20px; justify-content:flex-end;">
                            <div class="ah-legend-controls show">
                                <button id="ah-export-scan" class="button">Export CSV</button>
                                <button id="ah-show-details" class="button">Show Details</button>
                            </div>
                        </div>
                    </div>
                </div>

                <div id="ah-scan-details" style="margin-top:18px;">
                    <div id="ah-scan-status-text" style="display:block;margin-bottom:6px;color:#666;font-size:13px;"></div>
                    
                    <div class="ah-details-table-wrap">
                        <?php
                        $db = new DB();
                        $latest = $db->get_latest_scan();
                        $scan_id = $latest ? intval($latest->id) : 0;
                        
                        if ($scan_id > 0) {
                            // Use WP_List_Table for better table management
                            require_once dirname(__FILE__) . '/LinksListTable.php';
                            
                            // Get search and filters for passing to template
                            $search = isset($_REQUEST['s']) ? sanitize_text_field($_REQUEST['s']) : '';
                            $status_filter = isset($_REQUEST['status']) ? sanitize_text_field($_REQUEST['status']) : '';
                            $post_type_filter = isset($_REQUEST['post_type_filter']) ? sanitize_text_field($_REQUEST['post_type_filter']) : '';
                            $include_ignored = isset($_REQUEST['include_ignored']) ? (bool)$_REQUEST['include_ignored'] : false;
                            
                            $table = new LinksListTable(array('scan_id' => $scan_id));
                            $table->prepare_items();
                            ?>
                            
                            <form method="get" id="linkscanner-list-form" data-scan-id="<?php echo esc_attr($scan_id); ?>">
                                <input type="hidden" name="post_type" value="affiliate_link" />
                                <input type="hidden" name="page" value="affiliate-hub-link-scanner" />
                                
                                <!-- Search box -->
                                <?php $table->search_box(__('Search Links', 'affiliate-hub'), 'link'); ?>
                                
                                <!-- Status and Type filters -->
                                <div class="tablenav top">
                                    <div class="alignleft actions">
                                        <select name="status" id="ah-filter-status-table">
                                            <option value=""><?php _e('All statuses', 'affiliate-hub'); ?></option>
                                            <option value="pending" <?php selected($status_filter, 'pending'); ?>><?php _e('Pending', 'affiliate-hub'); ?></option>
                                            <option value="active" <?php selected($status_filter, 'active'); ?>><?php _e('Active', 'affiliate-hub'); ?></option>
                                            <option value="broken" <?php selected($status_filter, 'broken'); ?>><?php _e('Broken', 'affiliate-hub'); ?></option>
                                            <option value="forbidden" <?php selected($status_filter, 'forbidden'); ?>><?php _e('Forbidden', 'affiliate-hub'); ?></option>
                                            <option value="not_found" <?php selected($status_filter, 'not_found'); ?>><?php _e('Not Found (404)', 'affiliate-hub'); ?></option>
                                            <option value="server_error" <?php selected($status_filter, 'server_error'); ?>><?php _e('Server Error (5xx)', 'affiliate-hub'); ?></option>
                                            <option value="network_error" <?php selected($status_filter, 'network_error'); ?>><?php _e('Network Error', 'affiliate-hub'); ?></option>
                                            <option value="skipped" <?php selected($status_filter, 'skipped'); ?>><?php _e('Skipped', 'affiliate-hub'); ?></option>
                                        </select>
                                        
                                        <select name="post_type_filter" id="ah-filter-post-type" style="margin-left: 10px;">
                                            <option value=""><?php _e('All types', 'affiliate-hub'); ?></option>
                                            <option value="affiliate_link" <?php selected($post_type_filter, 'affiliate_link'); ?>><?php _e('Affiliate Links', 'affiliate-hub'); ?></option>
                                            <option value="post" <?php selected($post_type_filter, 'post'); ?>><?php _e('Posts', 'affiliate-hub'); ?></option>
                                            <option value="page" <?php selected($post_type_filter, 'page'); ?>><?php _e('Pages', 'affiliate-hub'); ?></option>
                                        </select>
                                        
                                        <label style="margin-left: 15px;">
                                            <input type="checkbox" name="include_ignored" id="ah-include-ignored" value="1" <?php checked($include_ignored); ?> />
                                            <?php _e('Include ignored', 'affiliate-hub'); ?>
                                        </label>
                                        
                                        <?php submit_button(__('Filter', 'affiliate-hub'), 'secondary', '', false, array('id' => 'doaction')); ?>
                                    </div>
                                </div>
                            </form>
                            
                            <form method="post" id="ah-links-form">
                                <?php $table->display(); ?>
                            </form>
                            
                            <?php
                        } else {
                            // No scans yet 
                            ?>
                            <p><?php _e('No scans found. Click the "Start Scan" button to begin your first scan.', 'affiliate-hub'); ?></p>
                            <?php
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}
