<?php
namespace AffiliateHub\Modules\LinkScanner;

class AdminPage {
    public function render() {
        ?>
        <div class="wrap">
            <h1><?php echo \esc_html(\__('Link Scanner', 'affiliate-hub')); ?></h1>
            
            <div class="notice notice-info" style="margin-bottom: 20px;">
                <p><?php echo sprintf(
                    \__('Configure Link Scanner settings (whitelist, blacklist, scan rate) in %s.', 'affiliate-hub'),
                    '<a href="' . admin_url('edit.php?post_type=affiliate_link&page=affiliate-hub-settings') . '">' . \__('Settings', 'affiliate-hub') . '</a>'
                ); ?></p>
            </div>
            
            <div id="ah-scan-status">
                <div style="display:flex; gap:24px; align-items:flex-start;">
                    <div style="flex:0 0 360px;">
                        <h2 style="margin-top:0;"><?php echo esc_html__('Scan filters & controls', 'affiliate-hub'); ?></h2>
                        
                        <!-- Scan Type Selection -->
                        <div style="margin-bottom:15px; padding:12px; background:#f9f9f9; border:1px solid #ddd; border-radius:4px;">
                            <label style="margin-bottom:8px; display:block;"><strong><?php echo esc_html__('Scan Type', 'affiliate-hub'); ?></strong></label>
                            <label style="display:block; margin-bottom:6px;">
                                <input type="radio" name="ah-scan-type" id="ah-scan-content" value="content" checked style="margin-right:8px;">
                                <?php echo esc_html__('Scan content links (posts, pages)', 'affiliate-hub'); ?>
                            </label>
                            <label style="display:block;">
                                <input type="radio" name="ah-scan-type" id="ah-scan-affiliates" value="affiliates" style="margin-right:8px;">
                                <?php echo esc_html__('Scan affiliate links destinations', 'affiliate-hub'); ?>
                            </label>
                            <p style="margin:8px 0 0 0; color:#666; font-size:13px;">
                                <?php echo esc_html__('Content scan checks links within posts/pages. Affiliate scan checks if your affiliate link destinations are working.', 'affiliate-hub'); ?>
                            </p>
                        </div>
                        
                        <!-- Post Types (only for content scan) -->
                        <div id="ah-post-types-container" style="margin-bottom:12px;">
                            <label for="ah-post-types"><strong><?php echo esc_html__('Post types', 'affiliate-hub'); ?></strong></label>
                            <select id="ah-post-types" multiple style="width:100%; min-height:120px;" data-placeholder="<?php echo esc_attr__('Select post types', 'affiliate-hub'); ?>"></select>
                        </div>
                                <!-- kept for filters but primary search appears above the table like WP list view -->
                                <div style="margin-bottom:12px; display:none;">
                                    <label for="ah-search"><strong><?php echo esc_html__('Search links', 'affiliate-hub'); ?></strong></label>
                                    <input type="search" id="ah-search" placeholder="<?php echo esc_attr__('Search URL, anchor text or note', 'affiliate-hub'); ?>" style="width:100%;" />
                                </div>
                        <div style="margin-bottom:12px; display:flex; gap:8px; align-items:center;">
                            <label for="ah-filter-status" style="margin:0;"><strong><?php echo esc_html__('Status', 'affiliate-hub'); ?></strong></label>
                            <select id="ah-filter-status" style="flex:1 1 auto;">
                                <option value=""><?php echo esc_html__('All', 'affiliate-hub'); ?></option>
                                <option value="pending"><?php echo esc_html__('Pending', 'affiliate-hub'); ?></option>
                                <option value="active"><?php echo esc_html__('Active', 'affiliate-hub'); ?></option>
                                <option value="broken"><?php echo esc_html__('Broken', 'affiliate-hub'); ?></option>
                                <option value="forbidden"><?php echo esc_html__('Forbidden', 'affiliate-hub'); ?></option>
                                <option value="skipped"><?php echo esc_html__('Skipped', 'affiliate-hub'); ?></option>
                            </select>
                        </div>
                        <div style="margin-bottom:12px;">
                            <button id="ah-start-scan" class="button button-primary"><?php echo \esc_html(\__('Start Scan', 'affiliate-hub')); ?></button>
                            <button id="ah-pause-scan" class="button" style="margin-left:8px; display:none;"><?php echo esc_html__('Pause', 'affiliate-hub'); ?></button>
                            <button id="ah-resume-scan" class="button" style="margin-left:8px; display:none;"><?php echo esc_html__('Resume', 'affiliate-hub'); ?></button>
                            <button id="ah-cancel-scan" class="button" style="margin-left:8px; display:none;"><?php echo esc_html__('Cancel', 'affiliate-hub'); ?></button>
                        </div>
                        <div>
                            <label style="vertical-align:middle;"><input type="checkbox" id="ah-show-ignored"> <?php echo esc_html__('Show ignored links', 'affiliate-hub'); ?></label>
                        </div>
                    </div>

                    <div style="flex:1 1 auto;">
                        <h2 style="margin-top:0;"><?php echo esc_html__('Summary', 'affiliate-hub'); ?></h2>
                        <div class="chart-wrapper">
                            <div id="ah-scan-chart"></div>
                            <!-- Lightweight progress bar shown for very large scans to avoid ApexCharts work -->
                            <div id="ah-scan-progress" style="display:none; width:100%;">
                                <div class="ah-progress-track"><div class="ah-progress-fill" style="width:0%"></div></div>
                                <div class="ah-progress-text" style="margin-top:6px;font-size:13px;color:#333;">0 / 0</div>
                            </div>
                        </div>
                        <div style="margin-top:10px; display:flex; align-items:center; gap:20px; justify-content:flex-end;">
                            <div class="ah-legend-controls show">
                                <button id="ah-export-scan" class="button">Export CSV</button>
                                <button id="ah-show-details" class="button">Show Details</button>
                            </div>
                        </div>
                    </div>
                </div>

                <div id="ah-scan-details" style="margin-top:18px;">
                    <div id="ah-scan-status-text" style="display:block;margin-bottom:6px;color:#666;font-size:13px;"></div>
                    <!-- NOTE: native WP_List_Table search box will be used here; avoid duplicating top table nav -->

                    <!-- Custom HTML table matching WordPress admin style -->
                    <div class="ah-details-table-wrap">
                        <?php
                        // Use WP_List_Table for better table management
                        require_once dirname(__FILE__) . '/LinksListTable.php';
                        
                        $db = new DB();
                        $latest = $db->get_latest_scan();
                        $scan_id = $latest ? intval($latest->id) : 0;
                        
                        // Get search and filters for passing to template
                        $search = isset($_REQUEST['s']) ? sanitize_text_field($_REQUEST['s']) : '';
                        $status_filter = isset($_REQUEST['status']) ? sanitize_text_field($_REQUEST['status']) : '';
                        $post_type_filter = isset($_REQUEST['post_type_filter']) ? sanitize_text_field($_REQUEST['post_type_filter']) : '';
                        $include_ignored = isset($_REQUEST['include_ignored']) ? (bool)$_REQUEST['include_ignored'] : false;
                        
                        $table = new LinksListTable(array('scan_id' => $scan_id));
                        $table->prepare_items();
                        ?>
                        
                        <form method="get" id="linkscanner-list-form" data-scan-id="<?php echo esc_attr($scan_id); ?>">
                            <input type="hidden" name="post_type" value="affiliate_link" />
                            <input type="hidden" name="page" value="affiliate-hub-link-scanner" />
                            
                            <!-- Search box -->
                            <?php $table->search_box(__('Search Links', 'affiliate-hub'), 'link'); ?>
                            
                            <!-- Status and Type filters -->
                            <div class="tablenav top">
                                <div class="alignleft actions">
                                    <select name="status" id="ah-filter-status">
                                        <option value=""><?php _e('All statuses', 'affiliate-hub'); ?></option>
                                        <option value="pending" <?php selected($status_filter, 'pending'); ?>><?php _e('Pending', 'affiliate-hub'); ?></option>
                                        <option value="active" <?php selected($status_filter, 'active'); ?>><?php _e('Active', 'affiliate-hub'); ?></option>
                                        <option value="broken" <?php selected($status_filter, 'broken'); ?>><?php _e('Broken', 'affiliate-hub'); ?></option>
                                        <option value="forbidden" <?php selected($status_filter, 'forbidden'); ?>><?php _e('Forbidden', 'affiliate-hub'); ?></option>
                                        <option value="skipped" <?php selected($status_filter, 'skipped'); ?>><?php _e('Skipped', 'affiliate-hub'); ?></option>
                                    </select>
                                    
                                    <select name="post_type_filter" id="ah-filter-post-type" style="margin-left: 10px;">
                                        <option value=""><?php _e('All types', 'affiliate-hub'); ?></option>
                                        <option value="affiliate_link" <?php selected($post_type_filter, 'affiliate_link'); ?>><?php _e('Affiliate Links', 'affiliate-hub'); ?></option>
                                        <option value="post" <?php selected($post_type_filter, 'post'); ?>><?php _e('Posts', 'affiliate-hub'); ?></option>
                                        <option value="page" <?php selected($post_type_filter, 'page'); ?>><?php _e('Pages', 'affiliate-hub'); ?></option>
                                    </select>
                                    
                                    <label style="margin-left: 15px;">
                                        <input type="checkbox" name="include_ignored" id="ah-include-ignored" value="1" <?php checked($include_ignored); ?> />
                                        <?php _e('Include ignored', 'affiliate-hub'); ?>
                                    </label>
                                    
                                    <?php submit_button(__('Filter', 'affiliate-hub'), 'secondary', '', false, array('id' => 'doaction')); ?>
                                </div>
                            </div>
                        </form>
                        
                        <form method="post" id="ah-links-form">
                            <?php $table->display(); ?>
                        </form>
                        ?>
                        
                        <!-- Status filter and controls -->
                        <div class="tablenav top">
                            <div class="alignleft actions">
                                <select name="status" id="ah-filter-status">
                                    <option value=""><?php _e('All statuses', 'affiliate-hub'); ?></option>
                                    <option value="pending" <?php selected($status_filter, 'pending'); ?>><?php _e('Pending', 'affiliate-hub'); ?></option>
                                    <option value="active" <?php selected($status_filter, 'active'); ?>><?php _e('Active', 'affiliate-hub'); ?></option>
                                    <option value="broken" <?php selected($status_filter, 'broken'); ?>><?php _e('Broken', 'affiliate-hub'); ?></option>
                                    <option value="forbidden" <?php selected($status_filter, 'forbidden'); ?>><?php _e('Forbidden', 'affiliate-hub'); ?></option>
                                    <option value="skipped" <?php selected($status_filter, 'skipped'); ?>><?php _e('Skipped', 'affiliate-hub'); ?></option>
                                </select>
                                
                                <select name="post_type_filter" id="ah-filter-post-type" style="margin-left: 10px;">
                                    <option value=""><?php _e('All types', 'affiliate-hub'); ?></option>
                                    <option value="affiliate_link" <?php selected($post_type_filter, 'affiliate_link'); ?>><?php _e('Affiliate Links', 'affiliate-hub'); ?></option>
                                    <option value="post" <?php selected($post_type_filter, 'post'); ?>><?php _e('Posts', 'affiliate-hub'); ?></option>
                                    <option value="page" <?php selected($post_type_filter, 'page'); ?>><?php _e('Pages', 'affiliate-hub'); ?></option>
                                </select>
                                
                                <input type="button" id="doaction" class="button action" value="<?php _e('Filter', 'affiliate-hub'); ?>" />
                                
                                <label style="margin-left: 15px;">
                                    <input type="checkbox" id="ah-show-ignored" <?php checked($include_ignored); ?> />
                                    <?php _e('Include ignored', 'affiliate-hub'); ?>
                                </label>
                            </div>
                            
                            <!-- Search box matching WordPress admin style -->
                            <p class="search-box">
                                <label class="screen-reader-text" for="ah-search"><?php _e('Search Links', 'affiliate-hub'); ?>:</label>
                                <input type="search" id="ah-search" name="s" value="<?php echo esc_attr($search); ?>" />
                                <input type="submit" id="search-submit" class="button" value="<?php _e('Search Links', 'affiliate-hub'); ?>" />
                            </p>
                            
                            <?php if ($total_items > $per_page): ?>
                            <div class="tablenav-pages">
                                <?php
                                $total_pages = ceil($total_items / $per_page);
                                echo paginate_links(array(
                                    'base' => add_query_arg('paged', '%#%'),
                                    'format' => '',
                                    'prev_text' => '&laquo;',
                                    'next_text' => '&raquo;',
                                    'total' => $total_pages,
                                    'current' => $current_page,
                                    'type' => 'plain'
                                ));
                                ?>
                            </div>
                            <?php endif; ?>
                        </div>
                        
                        <!-- Main table -->
                        <table class="wp-list-table widefat fixed striped">
                            <thead>
                                <tr>
                                    <th scope="col" class="manage-column column-cb check-column">
                                        <input id="cb-select-all-1" type="checkbox" />
                                    </th>
                                    <th scope="col" class="manage-column column-link<?php echo $orderby === 'link' ? ' sorted' : ' sortable'; ?> <?php echo $orderby === 'link' ? strtolower($order) : 'desc'; ?>">
                                        <a href="<?php echo esc_url(add_query_arg(array('orderby' => 'link', 'order' => ($orderby === 'link' && $order === 'ASC') ? 'desc' : 'asc'))); ?>">
                                            <span><?php _e('Link', 'affiliate-hub'); ?></span>
                                            <span class="sorting-indicator"></span>
                                        </a>
                                    </th>
                                    <th scope="col" class="manage-column column-label"><?php _e('Link Text', 'affiliate-hub'); ?></th>
                                    <th scope="col" class="manage-column column-post<?php echo $orderby === 'post' ? ' sorted' : ' sortable'; ?> <?php echo $orderby === 'post' ? strtolower($order) : 'desc'; ?>">
                                        <a href="<?php echo esc_url(add_query_arg(array('orderby' => 'post', 'order' => ($orderby === 'post' && $order === 'ASC') ? 'desc' : 'asc'))); ?>">
                                            <span><?php _e('Post', 'affiliate-hub'); ?></span>
                                            <span class="sorting-indicator"></span>
                                        </a>
                                    </th>
                                    <th scope="col" class="manage-column column-post-type"><?php _e('Post Type', 'affiliate-hub'); ?></th>
                                    <th scope="col" class="manage-column column-status<?php echo $orderby === 'status' ? ' sorted' : ' sortable'; ?> <?php echo $orderby === 'status' ? strtolower($order) : 'desc'; ?>">
                                        <a href="<?php echo esc_url(add_query_arg(array('orderby' => 'status', 'order' => ($orderby === 'status' && $order === 'ASC') ? 'desc' : 'asc'))); ?>">
                                            <span><?php _e('Status', 'affiliate-hub'); ?></span>
                                            <span class="sorting-indicator"></span>
                                        </a>
                                    </th>
                                    <th scope="col" class="manage-column column-code<?php echo $orderby === 'code' ? ' sorted' : ' sortable'; ?> <?php echo $orderby === 'code' ? strtolower($order) : 'desc'; ?>">
                                        <a href="<?php echo esc_url(add_query_arg(array('orderby' => 'code', 'order' => ($orderby === 'code' && $order === 'ASC') ? 'desc' : 'asc'))); ?>">
                                            <span><?php _e('Code', 'affiliate-hub'); ?></span>
                                            <span class="sorting-indicator"></span>
                                        </a>
                                    </th>
                                    <th scope="col" class="manage-column column-note"><?php _e('Note', 'affiliate-hub'); ?></th>
                                    <th scope="col" class="manage-column column-actions"><?php _e('Actions', 'affiliate-hub'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($links)): ?>
                                <tr class="no-items">
                                    <td class="colspanchange" colspan="9"><?php _e('No links found.', 'affiliate-hub'); ?></td>
                                </tr>
                                <?php else: ?>
                                    <?php foreach ($links as $link): ?>
                                    <tr data-id="<?php echo esc_attr($link->id); ?>" data-link-id="<?php echo esc_attr($link->id); ?>">
                                        <th scope="row" class="check-column">
                                            <input id="cb-select-<?php echo esc_attr($link->id); ?>" type="checkbox" name="scanned[]" value="<?php echo esc_attr($link->id); ?>" />
                                        </th>
                                        <td class="column-link">
                                            <a href="<?php echo esc_url($link->url); ?>" target="_blank" rel="noopener" title="<?php echo esc_attr($link->url); ?>">
                                                <?php echo esc_html(strlen($link->url) > 50 ? substr($link->url, 0, 50) . '...' : $link->url); ?>
                                            </a>
                                            <button type="button" class="button-link copy-url-btn" data-url="<?php echo esc_attr($link->url); ?>" title="<?php esc_attr_e('Copy URL', 'affiliate-hub'); ?>">
                                                <span class="dashicons dashicons-clipboard"></span>
                                            </button>
                                        </td>
                                        <td class="column-label">
                                            <?php 
                                            // Check if this is an affiliate link by looking at post_type
                                            $post_type = get_post_type($link->post_id);
                                            $is_affiliate = ($post_type === \AffiliateHub\Core\Constants::POST_TYPE_AFFILIATE_LINK);
                                            
                                            if ($is_affiliate): ?>
                                                <span class="dashicons dashicons-external" style="color: #0073aa;" title="<?php esc_attr_e('Affiliate Link Destination', 'affiliate-hub'); ?>"></span>
                                            <?php endif; ?>
                                            <?php echo esc_html($link->anchor_text); ?>
                                            <?php if ($link->anchor_text && $link->post_id): ?>
                                                <a href="<?php echo esc_url(admin_url('post.php?post=' . $link->post_id . '&action=edit')); ?>" 
                                                   target="_blank" 
                                                   class="open-link-btn" 
                                                   title="<?php esc_attr_e('Open post in editor', 'affiliate-hub'); ?>">
                                                    <span class="dashicons dashicons-external"></span>
                                                </a>
                                            <?php endif; ?>
                                        </td>
                                        <td class="column-post">
                                            <?php if ($link->post_id): ?>
                                                <a href="<?php echo esc_url(admin_url('post.php?post=' . $link->post_id . '&action=edit')); ?>" target="_blank">
                                                    #<?php echo esc_html($link->post_id); ?>
                                                </a>
                                                <a href="<?php echo esc_url(get_permalink($link->post_id)); ?>" 
                                                   target="_blank" 
                                                   class="open-link-btn" 
                                                   title="<?php esc_attr_e('View post on frontend', 'affiliate-hub'); ?>">
                                                    <span class="dashicons dashicons-external"></span>
                                                </a>
                                            <?php else: ?>
                                                —
                                            <?php endif; ?>
                                        </td>
                                        <td class="column-post-type">
                                            <?php if ($link->post_id): ?>
                                                <?php 
                                                $post_type = get_post_type($link->post_id);
                                                $post_type_names = array(
                                                    'post' => __('Wpis', 'affiliate-hub'),
                                                    'page' => __('Strona', 'affiliate-hub'),
                                                    'product' => __('Produkt', 'affiliate-hub'),
                                                    'attachment' => __('Załącznik', 'affiliate-hub'),
                                                    'affiliate_link' => __('Link Partnerski', 'affiliate-hub')
                                                );
                                                $display_name = isset($post_type_names[$post_type]) ? $post_type_names[$post_type] : ucfirst($post_type);
                                                echo esc_html($display_name);
                                                ?>
                                            <?php else: ?>
                                                —
                                            <?php endif; ?>
                                        </td>
                                        <td class="column-status">
                                            <?php
                                            $status_color = '#6c757d';
                                            if ($link->status === 'active') $status_color = '#28a745';
                                            elseif ($link->status === 'broken') $status_color = '#dc3545';
                                            elseif ($link->status === 'forbidden') $status_color = '#ffc107';
                                            ?>
                                            <span class="affiliate-hub-redirect-type" style="background-color: <?php echo esc_attr($status_color); ?>; color: #fff;">
                                                <?php echo esc_html($link->status); ?>
                                            </span>
                                        </td>
                                        <td class="column-code">
                                            <?php
                                            $code = intval($link->status_code);
                                            $code_color = '#6c757d';
                                            if ($code >= 200 && $code < 300) $code_color = '#28a745';
                                            elseif ($code >= 400 && $code < 500) $code_color = '#dc3545';
                                            elseif ($code >= 500) $code_color = '#b02a37';
                                            ?>
                                            <span class="affiliate-hub-redirect-type" style="background-color: <?php echo esc_attr($code_color); ?>; color: #fff;">
                                                <?php echo esc_html($code); ?>
                                            </span>
                                        </td>
                                        <td class="column-note">
                                            <?php 
                                            // Show affiliate link context if available
                                            if (!empty($link->context_snippet) && strpos($link->context_snippet, 'Affiliate Link:') === 0) {
                                                echo '<em style="color: #0073aa;">' . esc_html($link->context_snippet) . '</em>';
                                            } else {
                                                echo esc_html($link->note ?? ''); 
                                            }
                                            ?>
                                        </td>
                                        <td class="column-actions">
                                            <?php if (isset($link->ignored) && intval($link->ignored) === 1): ?>
                                                <button class="button ah-unignore-link" data-id="<?php echo esc_attr($link->id); ?>">
                                                    <?php _e('Un-ignore', 'affiliate-hub'); ?>
                                                </button>
                                            <?php else: ?>
                                                <button class="button ah-retry-link" data-id="<?php echo esc_attr($link->id); ?>">
                                                    <?php _e('Retry', 'affiliate-hub'); ?>
                                                </button>
                                                <button class="button ah-ignore-link" data-id="<?php echo esc_attr($link->id); ?>">
                                                    <?php _e('Ignore', 'affiliate-hub'); ?>
                                                </button>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                        
                        <!-- Bottom pagination -->
                        <?php if ($total_items > $per_page): ?>
                        <div class="tablenav bottom">
                            <div class="tablenav-pages">
                                <?php
                                echo paginate_links(array(
                                    'base' => add_query_arg('paged', '%#%'),
                                    'format' => '',
                                    'prev_text' => '&laquo;',
                                    'next_text' => '&raquo;',
                                    'total' => $total_pages,
                                    'current' => $current_page,
                                    'type' => 'plain'
                                ));
                                ?>
                            </div>
                        </div>
                        <?php endif; ?>
                        </form> <!-- Close form wrapper -->
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}
