Link Scanner Module for AffiliateHub

This module scans site posts for links, checks their HTTP status (active/broken/forbidden), and stores results in database tables. It provides an admin UI which uses Chart.js (already bundled) to display scan progress.

Key files:
- LinkScanner.php - module bootstrap and AJAX/cron integration
- Scanner.php - extracts links from posts
- DB.php - database helper for scans and scanned links
- HttpChecker.php - performs HTTP checks using wp_remote_head/get
- AdminPage.php - simple admin UI page
- assets/js/link-scanner-admin.js - admin UI JS with Chart.js polling

Notes:
- Uses WP-Cron for background batch processing (no ActionScheduler).
- Activation will create two tables: link_scans and scanned_links (via Activator).
- Default permissions: manage_options required to run scans.

Smoke test
----------
You can run a basic smoke test from the plugin root that boots WP and runs one batch:

php tools/run-linkscanner-smoke.php

This requires the script to be executed inside a WordPress installation that has the plugin present. The script will create a scan, queue links and process one batch synchronously.

## Tests

Run unit tests (requires phpunit installed globally or via composer):

```powershell
# from plugin root
phpunit
```

## Notes on migration

The module will automatically add missing `ignored` and `note` columns on init (via DB::ensure_schema()). Ensure the plugin is activated in a local WP instance to trigger migrations.
