<?php
/**
 * Module Interface
 *
 * @package AffiliateHub
 * @subpackage Modules
 */

namespace AffiliateHub\Modules;

/**
 * Interface for all modules
 */
interface ModuleInterface {
    
    /**
     * Initialize the module
     */
    public function init();
    
    /**
     * Get module information
     *
     * @return array
     */
    public function get_info();
    
    /**
     * Check if module is enabled
     *
     * @return bool
     */
    public function is_enabled();
}
