<?php
// Test table structure
require_once 'C:\xampp\htdocs\wp-test\wp-config.php';

global $wpdb;
$table = $wpdb->prefix . 'affiliate_hub_link_clicks';

echo "Checking table structure for: $table\n\n";

// Check if table exists
$table_exists = $wpdb->get_var("SHOW TABLES LIKE '$table'") == $table;
echo "Table exists: " . ($table_exists ? 'YES' : 'NO') . "\n\n";

if ($table_exists) {
    // Get columns
    $columns = $wpdb->get_results("DESCRIBE $table");
    echo "Columns in $table:\n";
    foreach($columns as $column) {
        echo "- " . $column->Field . " (" . $column->Type . ")\n";
    }
    
    // Get sample data
    echo "\nSample data (first 3 rows):\n";
    $sample = $wpdb->get_results("SELECT * FROM $table LIMIT 3", 'ARRAY_A');
    foreach($sample as $i => $row) {
        echo "\nRow " . ($i+1) . ":\n";
        foreach($row as $key => $value) {
            echo "  $key: " . (strlen($value) > 50 ? substr($value, 0, 50) . '...' : $value) . "\n";
        }
    }
    
    // Count total rows
    $count = $wpdb->get_var("SELECT COUNT(*) FROM $table");
    echo "\nTotal rows: $count\n";
}
