<?php
// Simple test of UserAgentParser

// Add namespace and class manually
namespace AffiliateHub\Modules {
    
class UserAgentParser {
    
    private $browsers = [
        'Edge' => '/Edg\/([0-9\.]+)/',  // New Chromium-based Edge
        'Edge Legacy' => '/Edge\/([0-9\.]+)/',  // Old Edge
        'Chrome' => '/Chrome\/([0-9\.]+)/',
        'Firefox' => '/Firefox\/([0-9\.]+)/',
        'Safari' => '/Safari\/[0-9\.]+ Version\/([0-9\.]+)/',
        'Opera' => '/(?:Opera|OPR)\/([0-9\.]+)/',
        'Internet Explorer' => '/MSIE ([0-9\.]+)/',
        'Internet Explorer 11' => '/Trident\/.*rv:([0-9\.]+)/'
    ];
    
    private function detect_browser($user_agent) {
        // Special case for Internet Explorer 11
        if (strpos($user_agent, 'Trident/') !== false && strpos($user_agent, 'rv:') !== false) {
            return 'Internet Explorer';
        }
        
        // Check other browsers
        foreach ($this->browsers as $browser => $pattern) {
            if (preg_match($pattern, $user_agent)) {
                return $browser === 'Internet Explorer 11' ? 'Internet Explorer' : $browser;
            }
        }
        
        return 'Unknown';
    }
    
    public function parse($user_agent) {
        return [
            'browser' => $this->detect_browser($user_agent),
            'browser_version' => '1.0',
            'os' => 'Windows',
            'os_version' => '10',
            'device_type' => 'Desktop'
        ];
    }
}

}

namespace {
    
// Test cases
$parser = new \AffiliateHub\Modules\UserAgentParser();

$test_cases = [
    'Chrome' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/118.0.0.0 Safari/537.36',
    'Firefox' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/119.0',
    'Edge' => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/118.0.0.0 Safari/537.36 Edg/118.0.2088.76'
];

echo "=== USER AGENT PARSER TEST ===\n";

foreach ($test_cases as $name => $ua) {
    echo "\n$name:\n";
    echo "UA: $ua\n";
    $result = $parser->parse($ua);
    echo "Browser: {$result['browser']}\n";
}

echo "\n=== DONE ===\n";

}
