<?php
use PHPUnit\Framework\TestCase;

require_once __DIR__ . '/bootstrap.php';

class ScannerTest extends TestCase {
    public function testExtractLinksSimple() {
        $html = '<p>Visit <a href="https://example.com/page">Example</a> and <a href="/about">About</a></p>';
        $s = new AffiliateHub\Modules\LinkScanner\Scanner();
        $links = $s->extract_links($html);
        $this->assertCount(2, $links);
        $this->assertEquals('https://example.com/page', $links[0]['url']);
        $this->assertEquals('https://example.org/about', $links[1]['url']);
    }

    public function testExcludedReturnsReason() {
        // simulate whitelist so that example.com will be excluded
        function get_option($name, $default = null) { return 'example.org'; }
        $html = '<a href="https://example.com">X</a>';
        $s = new AffiliateHub\Modules\LinkScanner\Scanner();
        $links = $s->extract_links($html);
        $this->assertCount(1, $links);
        $this->assertArrayHasKey('excluded', $links[0]);
        $this->assertEquals('not_in_whitelist', $links[0]['reason']);
    }
}
