<?php
/**
 * Database Table Checker for AffiliateHub
 * Run this file to check if tables are created properly
 */

// Include WordPress
require_once('../../../wp-config.php'); // Adjust path as needed

global $wpdb;

echo "<h2>AffiliateHub Database Tables Check</h2>\n";

// Check main table
$table_name = $wpdb->prefix . 'affiliate_hub_link_clicks';
$table_exists = $wpdb->get_var("SHOW TABLES LIKE '$table_name'");

echo "<h3>Table: $table_name</h3>\n";
if ($table_exists) {
    echo "✅ Table EXISTS<br>\n";
    
    // Check table structure
    $columns = $wpdb->get_results("DESCRIBE $table_name");
    echo "<h4>Table Structure:</h4>\n";
    echo "<ul>\n";
    foreach ($columns as $column) {
        echo "<li>{$column->Field} - {$column->Type}</li>\n";
    }
    echo "</ul>\n";
    
    // Check record count
    $count = $wpdb->get_var("SELECT COUNT(*) FROM $table_name");
    echo "<p><strong>Records count: $count</strong></p>\n";
    
    // Show sample records
    if ($count > 0) {
        $samples = $wpdb->get_results("SELECT * FROM $table_name ORDER BY clicked_at DESC LIMIT 5");
        echo "<h4>Sample Records:</h4>\n";
        echo "<table border='1'>\n";
        echo "<tr><th>ID</th><th>Link ID</th><th>IP</th><th>Clicked At</th><th>Browser</th><th>Country</th></tr>\n";
        foreach ($samples as $sample) {
            echo "<tr>";
            echo "<td>{$sample->id}</td>";
            echo "<td>{$sample->link_id}</td>";
            echo "<td>{$sample->ip_address}</td>";
            echo "<td>{$sample->clicked_at}</td>";
            echo "<td>{$sample->browser}</td>";
            echo "<td>{$sample->country}</td>";
            echo "</tr>\n";
        }
        echo "</table>\n";
    }
} else {
    echo "❌ Table DOES NOT EXIST<br>\n";
    echo "<p>Table needs to be created. Check plugin activation.</p>\n";
}

// Check WordPress posts table for affiliate links
$affiliate_links = $wpdb->get_var("SELECT COUNT(*) FROM {$wpdb->posts} WHERE post_type = 'affiliate_link'");
echo "<h3>Affiliate Links in Posts Table</h3>\n";
echo "<p>Count: $affiliate_links</p>\n";

echo "<h3>WordPress Database Info</h3>\n";
echo "<p>Database: " . DB_NAME . "</p>\n";
echo "<p>Table Prefix: " . $wpdb->prefix . "</p>\n";
