<?php
/**
 * Debug Script for Keywords Autolinker Issues
 * 
 * Add this as a shortcode to test functionality
 */

// Add shortcode for debugging
add_shortcode('debug_autolinker', function() {
    ob_start();
    
    echo '<div style="background: #f1f1f1; padding: 20px; margin: 20px 0; border-left: 4px solid #0073aa;">';
    echo '<h3>Keywords Autolinker Debug Information</h3>';
    
    // 1. Check if module is loaded
    $module_manager = \AffiliateHub\Modules\ModuleManager::get_instance();
    if ($module_manager) {
        echo '<p>✅ ModuleManager loaded</p>';
        
        $modules = $module_manager->get_modules();
        if (isset($modules['KeywordsAutolinker'])) {
            echo '<p>✅ KeywordsAutolinker module registered</p>';
        } else {
            echo '<p>❌ KeywordsAutolinker module NOT registered</p>';
        }
    } else {
        echo '<p>❌ ModuleManager NOT loaded</p>';
    }
    
    // 2. Check if AJAX actions are registered
    global $wp_filter;
    $ajax_actions = [
        'wp_ajax_affiliate_hub_check_keyword_conflict',
        'wp_ajax_affiliate_hub_rebuild_autolinker_cache',
        'wp_ajax_affiliate_hub_get_autolinker_stats'
    ];
    
    echo '<h4>AJAX Actions Status:</h4>';
    foreach ($ajax_actions as $action) {
        if (isset($wp_filter[$action])) {
            echo '<p>✅ ' . $action . ' - registered</p>';
        } else {
            echo '<p>❌ ' . $action . ' - NOT registered</p>';
        }
    }
    
    // 3. Check if post type exists
    $post_types = get_post_types();
    if (in_array('affiliate_link', $post_types)) {
        echo '<p>✅ affiliate_link post type exists</p>';
    } else {
        echo '<p>❌ affiliate_link post type NOT exists</p>';
    }
    
    // 4. Check database tables
    global $wpdb;
    $table_name = $wpdb->prefix . 'affiliate_hub_autolinker_cache';
    $table_exists = $wpdb->get_var("SHOW TABLES LIKE '$table_name'") === $table_name;
    if ($table_exists) {
        echo '<p>✅ Cache table exists</p>';
        $count = $wpdb->get_var("SELECT COUNT(*) FROM $table_name");
        echo '<p>📊 Cached keywords: ' . $count . '</p>';
    } else {
        echo '<p>❌ Cache table NOT exists</p>';
    }
    
    // 5. Test JavaScript loading
    if (is_admin()) {
        echo '<h4>Admin Assets Test:</h4>';
        echo '<p>Current hook: ' . (isset($GLOBALS['hook_suffix']) ? $GLOBALS['hook_suffix'] : 'unknown') . '</p>';
        
        if (wp_script_is('affiliate-hub-autolinker-admin', 'enqueued')) {
            echo '<p>✅ JavaScript enqueued</p>';
        } else {
            echo '<p>❌ JavaScript NOT enqueued</p>';
        }
        
        if (wp_style_is('affiliate-hub-autolinker-admin', 'enqueued')) {
            echo '<p>✅ CSS enqueued</p>';
        } else {
            echo '<p>❌ CSS NOT enqueued</p>';
        }
    }
    
    // 6. Manual AJAX test
    echo '<h4>Manual AJAX Test:</h4>';
    echo '<button id="test-ajax-conflict" class="button">Test Keyword Conflict Check</button>';
    echo '<div id="ajax-test-result"></div>';
    
    echo '<script>
    jQuery(document).ready(function($) {
        $("#test-ajax-conflict").click(function() {
            console.log("Testing AJAX...");
            
            var testData = {
                action: "affiliate_hub_check_keyword_conflict",
                keyword: "test keyword",
                post_id: 123,
                nonce: "' . wp_create_nonce('affiliate_hub_admin_nonce') . '"
            };
            
            console.log("Sending data:", testData);
            
            $.ajax({
                url: "' . admin_url('admin-ajax.php') . '",
                type: "POST",
                data: testData,
                success: function(response) {
                    console.log("AJAX Success:", response);
                    $("#ajax-test-result").html("<p style=\"color: green;\">✅ AJAX Success: " + JSON.stringify(response) + "</p>");
                },
                error: function(xhr, status, error) {
                    console.error("AJAX Error:", status, error);
                    console.error("Response:", xhr.responseText);
                    $("#ajax-test-result").html("<p style=\"color: red;\">❌ AJAX Error: " + status + " - " + error + "<br>Response: " + xhr.responseText + "</p>");
                }
            });
        });
    });
    </script>';
    
    echo '</div>';
    
    return ob_get_clean();
});

// Also add admin notice for debugging
add_action('admin_notices', function() {
    if (isset($_GET['debug_autolinker'])) {
        echo '<div class="notice notice-info is-dismissible">';
        echo '<p><strong>Debug Mode Active:</strong> Use shortcode [debug_autolinker] on any page to see debug info.</p>';
        echo '</div>';
    }
});
?>
