<?php
/**
 * Force Database Table Creation for AffiliateHub
 * Run this if tables are missing
 */

// Include WordPress files
if (!defined('ABSPATH')) {
    require_once('../../../wp-config.php');
}

// Include our Activator
require_once('../includes/Core/Activator.php');

use AffiliateHub\Core\Activator;

echo "<h1>Force Creating AffiliateHub Database Tables</h1>\n";

try {
    // Force table creation
    Activator::activate();
    echo "<p>✅ Database tables creation completed!</p>\n";
    
    // Check results
    global $wpdb;
    $table_name = $wpdb->prefix . 'affiliate_hub_link_clicks';
    $table_exists = $wpdb->get_var("SHOW TABLES LIKE '$table_name'");
    
    if ($table_exists) {
        echo "<p>✅ Table $table_name now exists!</p>\n";
        
        // Add some sample data for testing
        $wpdb->insert(
            $table_name,
            [
                'link_id' => 1,
                'ip_address' => '127.0.0.1',
                'user_agent' => 'Test User Agent',
                'referrer' => 'https://example.com',
                'country' => 'Poland',
                'country_code' => 'PL',
                'browser' => 'Chrome',
                'os' => 'Windows',
                'device_type' => 'Desktop',
                'is_unique' => 1,
                'is_unique_24h' => 1,
                'session_fingerprint' => 'test123',
                'clicked_at' => current_time('mysql')
            ]
        );
        
        echo "<p>✅ Sample data inserted for testing</p>\n";
    } else {
        echo "<p>❌ Table creation failed!</p>\n";
    }
    
} catch (Exception $e) {
    echo "<p>❌ Error: " . $e->getMessage() . "</p>\n";
}

echo "<p><a href='../admin.php?page=affiliate-hub-analytics'>Return to Analytics Dashboard</a></p>\n";
