<?php
// Simple smoke tester for LinkScanner module. Run from plugin root: php tools/run-linkscanner-smoke.php

// Try to locate WP bootstrapping
$root = __DIR__ . '/..';
$max = 6;
$found = false;
$path = realpath($root);
for ($i = 0; $i < $max; $i++) {
    if (file_exists($path . '/wp-load.php')) {
        require_once $path . '/wp-load.php';
        $found = true;
        break;
    }
    $path = dirname($path);
}
if (!$found) {
    echo "Could not find wp-load.php. Run this script from a WordPress install containing the plugin.\n";
    exit(1);
}

// Ensure plugin files are loaded
if (!class_exists('AffiliateHub\\Modules\\LinkScanner')) {
    // try to include plugin main file
    $plugin_file = __DIR__ . '/../affiliate-hub.php';
    if (file_exists($plugin_file)) {
        require_once $plugin_file;
    }
}

// Instantiate and run a small scan
$module = new \AffiliateHub\Modules\LinkScanner();
$module->init();

// Create a scan and queue links programmatically
$db = new \AffiliateHub\Modules\LinkScanner\DB();
$scanner = new \AffiliateHub\Modules\LinkScanner\Scanner();

$scan_id = $db->create_scan(array('started_at' => \current_time('mysql'), 'status' => 'pending', 'total_urls' => 0, 'processed' => 0));
$count = $scanner->queue_all_posts($scan_id);
$db->update_scan($scan_id, array('total_urls' => $count, 'status' => 'running'));

echo "Smoke test: queued $count links for scan $scan_id\n";

// Run one batch synchronously
$module->process_batch($scan_id);

$scan = $db->get_scan($scan_id);
echo "After one batch: processed={$scan->processed} total={$scan->total_urls} status={$scan->status}\n";

echo "Done.\n";
