<?php
/**
 * Autoloader for MaxMind GeoIP2 PHP API
 * 
 * Simplified autoloader for WordPress plugin environment
 * Loads only the classes we need for GeoLite2 database reading
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

class AffiliateHubGeoIP2Autoloader {
    private static $classes = array(
        // MaxMind\Db classes
        'MaxMind\Db\Reader' => 'maxmind/db/Reader.php',
        'MaxMind\Db\Reader\Decoder' => 'maxmind/db/Reader/Decoder.php', 
        'MaxMind\Db\Reader\InvalidDatabaseException' => 'maxmind/db/Reader/InvalidDatabaseException.php',
        'MaxMind\Db\Reader\Metadata' => 'maxmind/db/Reader/Metadata.php',
        'MaxMind\Db\Reader\Util' => 'maxmind/db/Reader/Util.php',
        
        // GeoIp2 classes
        'GeoIp2\Database\Reader' => 'geoip2/Database/Reader.php',
        'GeoIp2\Model\AbstractModel' => 'geoip2/Model/AbstractModel.php',
        'GeoIp2\Model\City' => 'geoip2/Model/City.php',
        'GeoIp2\Model\Country' => 'geoip2/Model/Country.php',
        'GeoIp2\Model\Insights' => 'geoip2/Model/Insights.php',
        'GeoIp2\Record\AbstractRecord' => 'geoip2/Record/AbstractRecord.php',
        'GeoIp2\Record\City' => 'geoip2/Record/City.php',
        'GeoIp2\Record\Continent' => 'geoip2/Record/Continent.php',
        'GeoIp2\Record\Country' => 'geoip2/Record/Country.php',
        'GeoIp2\Record\Location' => 'geoip2/Record/Location.php',
        'GeoIp2\Record\MaxMind' => 'geoip2/Record/MaxMind.php',
        'GeoIp2\Record\Postal' => 'geoip2/Record/Postal.php',
        'GeoIp2\Record\RepresentedCountry' => 'geoip2/Record/RepresentedCountry.php',
        'GeoIp2\Record\Subdivision' => 'geoip2/Record/Subdivision.php',
        'GeoIp2\Record\Traits' => 'geoip2/Record/Traits.php',
        
        // Exceptions
        'GeoIp2\Exception\GeoIp2Exception' => 'geoip2/Exception/GeoIp2Exception.php',
        'GeoIp2\Exception\AddressNotFoundException' => 'geoip2/Exception/AddressNotFoundException.php',
        'GeoIp2\Exception\AuthenticationException' => 'geoip2/Exception/AuthenticationException.php',
        'GeoIp2\Exception\InvalidRequestException' => 'geoip2/Exception/InvalidRequestException.php',
        'GeoIp2\Exception\OutOfQueriesException' => 'geoip2/Exception/OutOfQueriesException.php'
    );
    
    public static function register() {
        spl_autoload_register(array(__CLASS__, 'load'));
    }
    
    public static function load($class) {
        if (isset(self::$classes[$class])) {
            $file = __DIR__ . '/' . self::$classes[$class];
            if (file_exists($file)) {
                require_once $file;
                return true;
            }
        }
        return false;
    }
    
    /**
     * Check if GeoIP2 is available
     */
    public static function is_available() {
        return class_exists('GeoIp2\Database\Reader') || file_exists(__DIR__ . '/geoip2/Database/Reader.php');
    }
}

// Register the autoloader
AffiliateHubGeoIP2Autoloader::register();
