<?php
/**
 * GeoIP2 Database Reader - Simplified for WordPress
 */

namespace GeoIp2\Database;

use GeoIp2\Model\City;
use GeoIp2\Model\Country;
use MaxMind\Db\Reader as DbReader;

class Reader {
    private $dbReader;
    private $locales;
    
    public function __construct($database, $locales = array('en')) {
        $this->dbReader = new DbReader($database);
        $this->locales = $locales;
    }
    
    /**
     * Get city information for an IP address
     */
    public function city($ipAddress) {
        $record = $this->dbReader->get($ipAddress);
        return new City($record, $this->locales);
    }
    
    /**
     * Get country information for an IP address  
     */
    public function country($ipAddress) {
        $record = $this->dbReader->get($ipAddress);
        return new Country($record, $this->locales);
    }
    
    /**
     * Get database metadata
     */
    public function metadata() {
        return $this->dbReader->metadata();
    }
}
