<?php
/**
 * WordPress SSL/HTTPS Configuration Fix
 * Add these lines to your wp-config.php file (before "That's all, stop editing!")
 */

// SSL Configuration for WordPress.org connections
define('WP_HTTP_BLOCK_EXTERNAL', false);
define('WP_ACCESSIBLE_HOSTS', 'api.wordpress.org,downloads.wordpress.org,*.wordpress.org');

// Force SSL verification off (only for development/testing)
add_filter('https_ssl_verify', '__return_false');
add_filter('https_local_ssl_verify', '__return_false');

// Alternative: Use HTTP instead of HTTPS for WordPress.org requests
add_filter('pre_http_request', function($preempt, $parsed_args, $url) {
    if (strpos($url, 'api.wordpress.org') !== false) {
        $parsed_args['sslverify'] = false;
        $parsed_args['timeout'] = 30;
    }
    return $preempt;
}, 10, 3);

// Disable WordPress automatic updates if needed
// define('AUTOMATIC_UPDATER_DISABLED', true);
// define('WP_AUTO_UPDATE_CORE', false);

/**
 * INSTRUKCJE:
 * 1. Skopiuj odpowiednie linijki do wp-config.php
 * 2. Umieść je przed linią: "That's all, stop editing! Happy publishing."
 * 3. Zapisz plik i odśwież stronę
 */
